<?php include 'header-link.php'; ?>

<?php
// Fetch all offers with SIM names and area names
$sql = "
   SELECT all_drive_package.id, sim_entry.sim_name, district.dist_name, all_drive_package.offer_name, 
          all_drive_package.offer_amount, all_drive_package.offer_meyad, all_drive_package.offer_commision, 
          all_drive_package.offer_type 
   FROM all_drive_package 
   LEFT JOIN sim_entry ON all_drive_package.offer_sim = sim_entry.sim_id
   LEFT JOIN district ON all_drive_package.offer_area = district.dist_id
   ORDER BY all_drive_package.id DESC;
";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_id'])) {
    $delete_id = $_POST['delete_id'];
    // Prepare the DELETE query to remove the offer
    $delete_sql = "DELETE FROM all_drive_package WHERE id = ?";
    $stmt = $con->prepare($delete_sql);
    $stmt->bind_param("i", $delete_id);  // Bind the ID to the query
    $stmt->execute();
    // Redirect back to the offer list page after deletion
    header("Location: offer-list.php");
    exit();
}

$result = mysqli_query($con, $sql);
$offers = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $offers[] = $row;
    }
}

// Fetch all SIM names
$simSql = "SELECT * FROM sim_entry";
$simResult = mysqli_query($con, $simSql);
$sims = [];
if ($simResult) {
    while ($simRow = mysqli_fetch_assoc($simResult)) {
        $sims[] = $simRow;
    }
}

// Fetch all area names
$areaSql = "SELECT * FROM district";
$areaResult = mysqli_query($con, $areaSql);
$areas = [];
if ($areaResult) {
    while ($areaRow = mysqli_fetch_assoc($areaResult)) {
        $areas[] = $areaRow;
    }
}
?>


<main>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon  fa-duotone fa-solid fa-gifts"></i>
                            </div>

                            <h6 class="card-title text-center my-3"> All Offer List </h6>
                            <a class="btn btn-info m-3 d-block text-center " href="offer-add.php">Add New</a>
                            <div class="mb-3 d-none">
                                <select class="form-control text-center" name="SelectSim" id="categorySelect">
                                    <option value=""> --- সিম সিলেক্ট করুন --</option>
                                    <?php foreach ($sims as $sim): ?>
                                        <option value="<?php echo $sim['sim_id']; ?>"><?php echo $sim['sim_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <input type="text" class="form-control mb-4" id="searchInput" placeholder="অফার খুঁজুন..." onkeyup="filterOffers()">

                            <div class="offer-list" id="offerList">
                                <?php foreach ($offers as $offer): ?>
                                    <div class="offer-card mb-5 p-3" data-sim="<?php echo $offer['offer_sim']; ?>">
                                        <div class="row">
                                            <div class="col">
                                                <small class="fw-bold"> অফার: <?php echo $offer['offer_name']; ?></small><br>
                                                <small>মেয়াদ: <?php echo $offer['offer_meyad']; ?></small><br>
                                                <small> সিম: <?php echo $offer['sim_name']; ?> - <?php echo $offer['offer_type']; ?> </small>
                                            </div>
                                            <div class="col text-end">
                                                <small class="fw-bold">মূল্য: <?php echo $offer['offer_amount']; ?> ৳ </small><br>
                                                <small>কমিশন: <?php echo $offer['offer_commision']; ?> ৳ </small><br>
                                                <small> বিভাগ: <?php echo $offer['dist_name']; ?></small>
                                            </div>
                                        </div>
                                        <div class="d-grid text-center">
                                            <form action="" method="POST" style="display:inline;">
                                                <input type="hidden" name="delete_id" value="<?php echo $offer['id']; ?>"> <!-- Corrected here -->
                                                <button type="submit" class="btn custom-button w-50 mx-auto" onclick="return confirm('Do You Want To Delete ?')"> 
                                                    <i class="font fa-solid fa-trash"></i> Delete </button>
                                            </form>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<script>
function filterOffers() {
    const searchInput = document.getElementById('searchInput').value.toLowerCase();
    const categorySelect = document.getElementById('categorySelect').value;
    const offerCards = document.querySelectorAll('.offer-card');

    offerCards.forEach(card => {
        const offerText = Array.from(card.querySelectorAll('small')).map(small => small.textContent.toLowerCase()).join(' ');
        const offerSim = card.getAttribute('data-sim');

        const matchesSearch = offerText.includes(searchInput);
        const matchesSim = categorySelect === "" || offerSim === categorySelect;

        if (matchesSearch && matchesSim) {
            card.style.display = '';
        } else {
            card.style.display = 'none';
        }
    });
}

// Event listener for the SIM select dropdown
document.getElementById('categorySelect').addEventListener('change', filterOffers);
</script>

</body>
</html>
